/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbteamdimensions.client.DimensionsClient;
import dev.ftb.mods.ftbteamdimensions.mixin.LevelAccess;
import dev.ftb.mods.ftbteamdimensions.mixin.PersistentEntitySectionManagerAccess;
import dev.ftb.mods.ftbteamdimensions.mixin.ServerLevelAccess;
import dev.ftb.mods.ftbteamdimensions.net.FTBDimensionsNet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;

public class OpenVisitGui
extends BaseS2CMessage {
    private final Map<ResourceLocation, DimData> dimensionData;

    public OpenVisitGui(Map<ResourceLocation, DimData> dimensionData) {
        this.dimensionData = dimensionData;
    }

    public OpenVisitGui(FriendlyByteBuf buf) {
        this.dimensionData = new HashMap<ResourceLocation, DimData>();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.dimensionData.put(buf.m_130281_(), DimData.fromNetwork(buf));
        }
    }

    public MessageType getType() {
        return FTBDimensionsNet.OPEN_VISIT_GUI;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.dimensionData.size());
        this.dimensionData.forEach((id, data) -> {
            buf.m_130085_(id);
            data.toNetwork(buf);
        });
    }

    public void handle(NetworkManager.PacketContext context) {
        DimensionsClient.openVisitScreen(this.dimensionData);
    }

    public record DimData(String teamName, double tickTime, boolean archived, int blockEntities, int entities, int loadedChunks) {
        public static DimData fromNetwork(FriendlyByteBuf buf) {
            String teamName = buf.m_130136_(Short.MAX_VALUE);
            double tickTime = buf.readDouble();
            boolean archived = buf.readBoolean();
            int blockEntities = buf.readInt();
            int entities = buf.readInt();
            int loadedChunks = buf.m_130242_();
            return new DimData(teamName, tickTime, archived, blockEntities, entities, loadedChunks);
        }

        public static DimData create(ServerLevel level, String teamName, boolean archived) {
            int beCount = ((LevelAccess)level).getBlockEntityTickers().size();
            PersistentEntitySectionManager<Entity> m = ((ServerLevelAccess)level).getEntityManager();
            int eCount = ((PersistentEntitySectionManagerAccess)m).getKnownUuids().size();
            int lcCount = level.m_7726_().m_8482_();
            return new DimData(teamName, DimData.getTickTime(level.m_7654_(), (ResourceKey<Level>)level.m_46472_()), archived, beCount, eCount, lcCount);
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130070_(this.teamName);
            buf.writeDouble(this.tickTime);
            buf.writeBoolean(this.archived);
            buf.writeInt(this.blockEntities);
            buf.writeInt(this.entities);
            buf.m_130130_(this.loadedChunks);
        }

        private static double getTickTime(MinecraftServer server, ResourceKey<Level> key) {
            long[] times = server.getTickTime(key);
            if (times == null) {
                times = new long[]{0L};
            }
            return (double)DimData.mean(times) * 1.0E-6;
        }

        private static long mean(long[] values) {
            long sum = 0L;
            for (long v : values) {
                sum += v;
            }
            return sum / (long)values.length;
        }
    }
}

